'use strict';

module.exports = function (grunt) {

	require('load-grunt-tasks')(grunt);

	// Time how long tasks take. Can help when optimizing build times
	require('time-grunt')(grunt);

	var pkg = grunt.file.readJSON('package.json');

	// Define the configuration for all the tasks
	grunt.initConfig({
		pkg: require('./package.json'),

		// Project settings
		yeoman: {
		  	// configurable paths
		 	app: require('./bower.json').appPath || 'app',
			dist: 'dist'
		},
		replace: {
			resource: {
				options: {
					patterns: [
						{
							match: /\{baseUrl\}/g,
							replacement: '<%= replace.baseUrl %>'
						}
					]
				},
				files: [
					{expand: true, flatten: true, src: ['app/resources.json'], dest: 'dist'}
				]
			}
		}
	});


	// load per-task config from separate files found in grunt directory
	grunt.loadTasks('grunt');

	grunt.registerTask('serve', function (target) {
		if (target === 'dist') {
		  return grunt.task.run(['build:dev', 'connect:dist:keepalive']);
		}

		grunt.task.run([
			'clean:server',
			'concurrent:server',
			'autoprefixer',
			'connect:livereload',
			'watch'
		]);
	});

	grunt.registerTask('server', function (target) {
		grunt.log.warn('The `server` task has been deprecated. Use `grunt serve` to start a server.');
		grunt.task.run(['serve:' + target]);
	});

	grunt.registerTask('replace-resource', "replace resource's baseUrl", function() {
		grunt.config.set('replace.baseUrl', grunt.option('baseUrl'));
		grunt.task.run('replace:resource');
	});

	grunt.registerTask('buildResourceDirectory', 'Transform resource-directory.json so it has the patch level urls', function(){
		var rawResourceDirectoryString = grunt.file.read('dist/resources.json');
		var versionElements = pkg.version.split('.');
		var versionUrlSegment = 'v' + versionElements[0] + '/m' + versionElements[1] + '/p' + versionElements[2];
		var directoryStringWithVersioning = rawResourceDirectoryString.replace(/{full-version}/g,versionUrlSegment);
		grunt.file.write('dist/resources.json',directoryStringWithVersioning);
	});

	grunt.registerTask('test', [
		'clean:server',
		'clean:coverage',
		'concurrent:test',
		'autoprefixer',
		'connect:test',
		'karma'
	]);

	grunt.registerTask('build:dev', [
		'clean:dist',
		'useminPrepare',
		'concurrent:dist',
		'autoprefixer',
		'concat',
		'ngtemplates',
		'copy:dev',
		'targethtml:dev',
		'cdnify',
		'cssmin:generated',
		'uglify:generated',
		'usemin',
		'replace-resource',
		'buildResourceDirectory'
	]);

	grunt.registerTask('build:dist', [
		'clean:dist',
		'useminPrepare',
		'concurrent:dist',
		'autoprefixer',
		'concat',
		'copy:dist',
		'targethtml:prod',
		'cdnify',
		'cssmin:generated',
		'uglify:generated',
		'usemin',
		'ngtemplates',
		'requirejs',
		'replace-resource',
		'buildResourceDirectory'
	]);

	grunt.registerTask('default', [
		'newer:jshint',
		'test',
		'build'
	]);

	grunt.registerTask('bowerCopy', [
		'bower-linker:dev'
	]);
};
